<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   role
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['addinganewrole'] = 'Adding a new role';
$string['addingrolebycopying'] = 'Adding a new role based on {$a}';
$string['addrole'] = 'Add a new role';
$string['advancedoverride'] = 'Advanced role override';
$string['allow'] = 'Allow';
$string['allowassign'] = 'Allow role assignments';
$string['allowed'] = 'Allowed';
$string['allowoverride'] = 'Allow role overrides';
$string['allowroletoassign'] = 'Allow users with role {$a->fromrole} to assign the role {$a->targetrole}';
$string['allowroletooverride'] = 'Allow users with role {$a->fromrole} to override the role {$a->targetrole}';
$string['allowroletoswitch'] = 'Allow users with role {$a->fromrole} to switch roles to the role {$a->targetrole}';
$string['allowswitch'] = 'Allow role switches';
$string['allsiteusers'] = 'All site users';
$string['archetype'] = 'Role archetype';
$string['archetype_help'] = 'The role archetype determines the permissions when a role is reset to default. It also determines any new permissions for the role when the site is upgraded.';
$string['archetypecoursecreator'] = 'ARCHETYPE: Course creator';
$string['archetypeeditingteacher'] = 'ARCHETYPE: Teacher (editing)';
$string['archetypefrontpage'] = 'ARCHETYPE: Authenticated user on frontpage';
$string['archetypeguest'] = 'ARCHETYPE: Guest';
$string['archetypemanager'] = 'ARCHETYPE: Manager';
$string['archetypestudent'] = 'ARCHETYPE: Student';
$string['archetypeteacher'] = 'ARCHETYPE: Teacher (non-editing)';
$string['archetypeuser'] = 'ARCHETYPE: Authenticated user';
$string['assignanotherrole'] = 'Assign another role';
$string['assignerror'] = 'Error while assigning the role {$a->role} to user {$a->user}.';
$string['assignglobalroles'] = 'Assign system roles';
$string['assignedroles'] = 'Assigned roles';
$string['assignmentcontext'] = 'Assignment context';
$string['assignmentoptions'] = 'Assignment options';
$string['assignrolenameincontext'] = 'Assign role \'{$a->role}\' in {$a->context}';
$string['assignrole'] = 'Assign role';
$string['assignroles'] = 'Assign roles';
$string['assignroles_help'] = 'By assigning a role to a user in a context, you are granting them the permissions contained in that role, for the current context and all lower contexts. For example, if a user is assigned the role of student in a course, they will also have the role of student for all activities and blocks within the course.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Assign roles in {$a}';
$string['assignrolesrelativetothisuser'] = 'Assign roles relative to this user';
$string['backtoallroles'] = 'Back to the list of all roles';
$string['backup:anonymise'] = 'Anonymise user data on backup';
$string['backup:backupactivity'] = 'Backup activities';
$string['backup:backupcourse'] = 'Backup courses';
$string['backup:backupsection'] = 'Backup sections';
$string['backup:configure'] = 'Configure backup options';
$string['backup:downloadfile'] = 'Download files from backup areas';
$string['backup:backuptargethub'] = 'Backup for hub';
$string['backup:backuptargetimport'] = 'Backup for import';
$string['backup:userinfo'] = 'Backup user data';
$string['block:edit'] = 'Edit a block\'s settings';
$string['block:view'] = 'View block';
$string['blog:associatecourse'] = 'Associate blog entries with courses';
$string['blog:associatemodule'] = 'Associate blog entries with activity modules';
$string['blog:create'] = 'Create new blog entries';
$string['blog:manageentries'] = 'Edit and manage entries';
$string['blog:manageexternal'] = 'Edit and manage external blogs';
$string['blog:manageofficialtags'] = 'Manage official tags';
$string['blog:managepersonaltags'] = 'Manage personal tags';
$string['blog:search'] = 'Search blog entries';
$string['blog:view'] = 'View blog entries';
$string['blog:viewdrafts'] = 'View draft blog entries';
$string['calendar:manageentries'] = 'Manage any calendar entries';
$string['calendar:managegroupentries'] = 'Manage group calendar entries';
$string['calendar:manageownentries'] = 'Manage own calendar entries';
$string['capabilities'] = 'Capabilities';
$string['capability'] = 'Capability';
$string['category:create'] = 'Create categories';
$string['category:delete'] = 'Delete categories';
$string['category:manage'] = 'Manage categories';
$string['category:update'] = 'Update categories';
$string['category:viewhiddencategories'] = 'See hidden categories';
$string['category:visibility'] = 'See hidden categories';
$string['cohort:assign'] = 'Add and remove cohort members';
$string['cohort:view'] = 'View site-wide cohorts';
$string['cohort:manage'] = 'Create, delete and move cohorts';
$string['comment:delete'] = 'Delete comments';
$string['comment:post'] = 'Post comments';
$string['comment:view'] = 'Read comments';
$string['community:add'] = 'Use the community block to search hubs and find courses';
$string['community:download'] = 'Download a course from the community block';
$string['confirmaddadmin'] = 'Do you really want to add user <strong>{$a}</strong> as new site administrator?';
$string['confirmdeladmin'] = 'Do you really want to remove user <strong>{$a}</strong> from the list of site administrators?';
$string['confirmroleprevent'] = 'Do you really want to remove <strong>{$a->role}</strong> from the list of allowed roles for capability {$a->cap} in context {$a->context}?';
$string['confirmroleunprohibit'] = 'Do you really want to remove <strong>{$a->role}</strong> from the list of prohibited roles for capability {$a->cap} in context {$a->context}?';
$string['confirmunassign'] = 'Are you sure you wish to remove this role from this user?';
$string['confirmunassigntitle'] = 'Confirm role change';
$string['confirmunassignyes'] = 'Remove';
$string['confirmunassignno'] = 'Cancel';
$string['context'] = 'Context';
$string['course:activityvisibility'] = 'Hide/show activities';
$string['course:bulkmessaging'] = 'Send a message to many people';
$string['course:create'] = 'Create courses';
$string['course:delete'] = 'Delete courses';
$string['course:changecategory'] = 'Change course category';
$string['course:changefullname'] = 'Change course full name';
$string['course:changeidnumber'] = 'Change course ID number';
$string['course:changeshortname'] = 'Change course short name';
$string['course:changesummary'] = 'Change course summary';
$string['course:enrolconfig'] = 'Configure enrol instances in courses';
$string['course:enrolreview'] = 'Review course enrolments';
$string['course:ignorefilesizelimits'] = 'Use files larger than any file size restrictions';
$string['course:isincompletionreports'] = 'Be shown on completion reports';
$string['course:manageactivities'] = 'Manage activities';
$string['course:managefiles'] = 'Manage files';
$string['course:managegrades'] = 'Manage grades';
$string['course:managegroups'] = 'Manage groups';
$string['course:managescales'] = 'Manage scales';
$string['course:markcomplete'] = 'Mark users as complete in course completion';
$string['course:movesections'] = 'Move sections';
$string['course:publish'] = 'Publish a course into hub';
$string['course:request'] = 'Request new courses';
$string['course:reset'] = 'Reset course';
$string['course:sectionvisibility'] = 'Control section visibility';
$string['course:setcurrentsection'] = 'Set current section';
$string['course:update'] = 'Update course settings';
$string['course:useremail'] = 'Enable/disable email address';
$string['course:view'] = 'View courses without participation';
$string['course:viewcoursegrades'] = 'View course grades';
$string['course:viewhiddenactivities'] = 'View hidden activities';
$string['course:viewhiddencourses'] = 'View hidden courses';
$string['course:viewhiddensections'] = 'View hidden sections';
$string['course:viewhiddenuserfields'] = 'View hidden user fields';
$string['course:viewparticipants'] = 'View participants';
$string['course:viewscales'] = 'View scales';
$string['course:visibility'] = 'Hide/show courses';
$string['createrolebycopying'] = 'Create a new role by copying {$a}';
$string['createthisrole'] = 'Create this role';
$string['currentcontext'] = 'Current context';
$string['currentrole'] = 'Current role';
$string['customroledescription'] = 'Custom description';
$string['customroledescription_help'] = 'Descriptions of standard roles are localised automatically if the custom description is empty.';
$string['customrolename'] = 'Custom full name';
$string['customrolename_help'] = 'Names of standard roles are localised automatically if the custom name is empty. You must provide a full name for all custom roles.';
$string['defaultrole'] = 'Default role';
$string['defaultx'] = 'Default: {$a}';
$string['defineroles'] = 'Define roles';
$string['deletecourseoverrides'] = 'Delete all overrides in course';
$string['deletelocalroles'] = 'Delete all local role assignments';
$string['deleterolesure'] = 'Are you sure that you want to delete role "{$a->name} ({$a->shortname})"?</p><p>Currently this role is assigned to {$a->count} users.';
$string['deletexrole'] = 'Delete {$a} role';
$string['duplicaterole'] = 'Duplicate role';
$string['duplicaterolesure'] = 'Are you sure that you want to duplicate role "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Editing role \'{$a}\'';
$string['editrole'] = 'Edit role';
$string['editxrole'] = 'Edit {$a} role';
$string['errorbadrolename'] = 'Incorrect role name';
$string['errorbadroleshortname'] = 'Incorrect role short name';
$string['errorexistsrolename'] = 'Role name already exists';
$string['errorexistsroleshortname'] = 'Role name already exists';
$string['existingadmins'] = 'Current site administrators';
$string['existingusers'] = '{$a} existing users';
$string['explanation'] = 'Explanation';
$string['extusers'] = 'Existing users';
$string['extusersmatching'] = 'Existing users matching \'{$a}\'';
$string['filter:manage'] = 'Manage local filter settings';
$string['frontpageuser'] = 'Authenticated user on frontpage';
$string['frontpageuserdescription'] = 'All logged in users in the frontpage course.';
$string['globalrole'] = 'System role';
$string['globalroleswarning'] = 'WARNING! Any roles you assign from this page will apply to the assigned users throughout the entire system, including the front page and all the courses.';
$string['gotoassignroles'] = 'Go to Assign roles for this {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Go to Assign system roles';
$string['grade:edit'] = 'Edit grades';
$string['grade:export'] = 'Export grades';
$string['grade:hide'] = 'Hide/unhide grades or items';
$string['grade:import'] = 'Import grades';
$string['grade:lock'] = 'Lock grades or items';
$string['grade:manage'] = 'Manage grade items';
$string['grade:managegradingforms'] = 'Manage advanced grading methods';
$string['grade:managesharedforms'] = 'Manage advanced grading form templates';
$string['grade:sharegradingforms'] = 'Share advanced grading form as a template';
$string['grade:manageletters'] = 'Manage letter grades';
$string['grade:manageoutcomes'] = 'Manage grade outcomes';
$string['grade:override'] = 'Override grades';
$string['grade:unlock'] = 'Unlock grades or items';
$string['grade:view'] = 'View own grades';
$string['grade:viewall'] = 'View grades of other users';
$string['grade:viewhidden'] = 'View hidden grades for owner';
$string['hidden'] = 'Hidden';
$string['highlightedcellsshowdefault'] = 'The permissions selected in the table below are the defaults for the role archetype selected above.';
$string['highlightedcellsshowinherit'] = 'The highlighted cells in the table below show the permission (if any) that will be inherited. Apart from the capabilities whose permission you actually want to alter, you should leave everything set to Inherit.';
$string['checkglobalpermissions'] = 'Check system permissions';
$string['checkpermissions'] = 'Check permissions';
$string['checkpermissionsin'] = 'Check permissions in {$a}';
$string['checksystempermissionsfor'] = 'Check system permissions for {$a->fullname}';
$string['checkuserspermissionshere'] = 'Check permissions for {$a->fullname} has in this {$a->contextlevel}';
$string['chooseroletoassign'] = 'Please choose a role to assign';
$string['inactiveformorethan'] = 'inactive for more than {$a->timeperiod}';
$string['ingroup'] = 'in the group "{$a->group}"';
$string['inherit'] = 'Inherit';
$string['legacy:admin'] = 'LEGACY ROLE: Administrator';
$string['legacy:coursecreator'] = 'LEGACY ROLE: Course creator';
$string['legacy:editingteacher'] = 'LEGACY ROLE: Teacher (editing)';
$string['legacy:guest'] = 'LEGACY ROLE: Guest';
$string['legacy:student'] = 'LEGACY ROLE: Student';
$string['legacy:teacher'] = 'LEGACY ROLE: Teacher (non-editing)';
$string['legacytype'] = 'Legacy role type';
$string['legacy:user'] = 'LEGACY ROLE: Authenticated user';
$string['listallroles'] = 'List all roles';
$string['localroles'] = 'Locally assigned roles';
$string['mainadmin'] = 'Main administrator';
$string['mainadminset'] = 'Set main admin';
$string['manageadmins'] = 'Manage site administrators';
$string['manager'] = 'Manager';
$string['managerdescription'] = 'Managers can access course and modify them, they usually do not participate in courses.';
$string['manageroles'] = 'Manage roles';
$string['maybeassignedin'] = 'Context types where this role may be assigned';
$string['morethan'] = 'More than {$a}';
$string['multipleroles'] = 'Multiple roles';
$string['my:manageblocks'] = 'Manage My Moodle page blocks';
$string['my:configsyspages'] = 'Configure system templates for My Moodle pages';
$string['neededroles'] = 'Roles with permission';
$string['nocapabilitiesincontext'] = 'No capabilities available in this context';
$string['noneinthisx'] = 'None in this {$a}';
$string['noneinthisxmatching'] = 'No users matching \'{$a->search}\' in this {$a->contexttype}';
$string['noroles'] = 'No roles';
$string['noroleassignments'] = 'This user does not have any role assignments anywhere in this site.';
$string['notabletoassignroleshere'] = 'You are not able to assign any roles here';
$string['notabletooverrideroleshere'] = 'You are not able to override the permissions on any roles here';
$string['notes:manage'] = 'Manage notes';
$string['notes:view'] = 'View notes';
$string['notset'] = 'Not set';
$string['overrideanotherrole'] = 'Override another role';
$string['overridecontext'] = 'Override context';
$string['overridepermissions'] = 'Override permissions';
$string['overridepermissions_help'] = 'Permissions overrides enable selected capabilities to be allowed or prevented in a specific context.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Override permissions for role \'{$a->role}\' in {$a->context}';
$string['overridepermissionsin'] = 'Override permissions in {$a}';
$string['overrideroles'] = 'Override roles';
$string['overriderolesin'] = 'Override roles in {$a}';
$string['overrides'] = 'Overrides';
$string['overridesbycontext'] = 'Overrides (by context)';
$string['permission'] = 'Permission';
$string['permission_help'] = 'Permissions are capability settings. There are 4 options:

* Not set
* Allow - Permission is granted for the capability
* Prevent - Permission is removed for the capability, even if allowed in a higher context
* Prohibit - Permission is completely denied  and cannot be overridden at any lower (more specific) context';
$string['permissions'] = 'Permissions';
$string['permissionsforuser'] = 'Permissions for user {$a}';
$string['permissionsincontext'] = 'Permissions in {$a}';
$string['portfolio:export'] = 'Export to portfolios';
$string['potentialusers'] = '{$a} potential users';
$string['potusers'] = 'Potential users';
$string['potusersmatching'] = 'Potential users matching \'{$a}\'';
$string['prevent'] = 'Prevent';
$string['prohibit'] = 'Prohibit';
$string['prohibitedroles'] = 'Prohibited';
$string['question:add'] = 'Add new questions';
$string['question:config'] = 'Configure question types';
$string['question:editall'] = 'Edit all questions';
$string['question:editmine'] = 'Edit your own questions';
$string['question:flag'] = 'Flag questions while attempting them';
$string['question:managecategory'] = 'Edit question categories';
$string['question:moveall'] = 'Move all questions';
$string['question:movemine'] = 'Move your own questions';
$string['question:useall'] = 'Use all questions';
$string['question:usemine'] = 'Use your own questions';
$string['question:viewall'] = 'View all questions';
$string['question:viewmine'] = 'View your own questions';
$string['rating:rate'] = 'Add ratings to items';
$string['rating:view'] = 'View the total rating you received';
$string['rating:viewany'] = 'View total ratings that anyone received';
$string['rating:viewall'] = 'View all raw ratings given by individuals';
$string['resetrole'] = 'Reset to defaults';
$string['resetrolenolegacy'] = 'Clear permissions';
$string['resetrolesure'] = 'Are you sure that you want to reset role "{$a->name} ({$a->shortname})" to defaults?<p></p>The defaults are taken from the selected archetype ({$a->legacytype}).';
$string['resetrolesurenolegacy'] = 'Are you sure that you want to clear all permissions defined in this role "{$a->name} ({$a->shortname})"?';
$string['restore:configure'] = 'Configure restore options';
$string['restore:createuser'] = 'Create users on restore';
$string['restore:restoreactivity'] = 'Restore activities';
$string['restore:restoresection'] = 'Restore sections';
$string['restore:restorecourse'] = 'Restore courses';
$string['restore:restoretargethub'] = 'Restore from files targeted as hub';
$string['restore:restoretargetimport'] = 'Restore from files targeted as import';
$string['restore:rolldates'] = 'Allowed to roll activity configuration dates on restore';
$string['restore:uploadfile'] = 'Upload files to backup areas';
$string['restore:userinfo'] = 'Restore user data';
$string['restore:viewautomatedfilearea'] = 'Restore courses from automated backups';
$string['risks'] = 'Risks';
$string['roleallowheader'] = 'Allow role:';
$string['roleallowinfo'] = 'Select a role to be added to the list of allowed roles in context {$a->context}, capability {$a->cap}:';
$string['role:assign'] = 'Assign roles to users';
$string['roleassignments'] = 'Role assignments';
$string['roledefinitions'] = 'Role definitions';
$string['rolefullname'] = 'Role name';
$string['roleincontext'] = '{$a->role} in {$a->context}';
$string['role:manage'] = 'Create and manage roles';
$string['role:override'] = 'Override permissions for others';
$string['role:review'] = 'Review permissions for others';
$string['roleprohibitheader'] = 'Prohibit role';
$string['roleprohibitinfo'] = 'Select a role to be added to the list of prohibited roles in context {$a->context}, capability {$a->cap}:';
$string['roles'] = 'Roles';
$string['roles_help'] = 'A role is a collection of permissions defined for the whole system that you can assign to specific users in specific contexts.';
$string['roles_link'] = 'roles';
$string['role:safeoverride'] = 'Override safe permissions for others';
$string['roleselect'] = 'Select role';
$string['rolesforuser'] = 'Roles for user {$a}';
$string['roleshortname'] = 'Short name';
$string['roleshortname_help'] = 'Role short name is a low level role identifier in which only ASCII alphanumeric characters are allowed. Do not change short names of standard roles.';
$string['role:switchroles'] = 'Switch to other roles';
$string['roletoassign'] = 'Role to assign';
$string['roletooverride'] = 'Role to override';
$string['safeoverridenotice'] = 'Note: Capabilities with higher risks are locked because you are only allowed to override safe capabilities.';
$string['selectanotheruser'] = 'Select another user';
$string['selectauser'] = 'Select a user';
$string['selectrole'] = 'Select a role';
$string['showallroles'] = 'Show all roles';
$string['showthisuserspermissions'] = 'Show this user\'s permissions';
$string['site:accessallgroups'] = 'Access all groups';
$string['siteadministrators'] = 'Site administrators';
$string['site:approvecourse'] = 'Approve course creation';
$string['site:backup'] = 'Backup courses';
$string['site:config'] = 'Change site configuration';
$string['site:doanything'] = 'Allowed to do everything';
$string['site:doclinks'] = 'Show links to offsite docs';
$string['site:import'] = 'Import other courses into a course';
$string['site:manageblocks'] = 'Manage blocks on a page';
$string['site:mnetloginfromremote'] = 'Login from a remote application via MNet';
$string['site:mnetlogintoremote'] = 'Roam to a remote application via MNet';
$string['site:readallmessages'] = 'Read all messages on site';
$string['site:restore'] = 'Restore courses';
$string['site:sendmessage'] = 'Send messages to any user';
$string['site:trustcontent'] = 'Trust submitted content';
$string['site:uploadusers'] = 'Upload new users from file';
$string['site:viewfullnames'] = 'Always see full names of users';
$string['site:viewparticipants'] = 'View participants';
$string['site:viewreports'] = 'View reports';
$string['site:viewuseridentity'] = 'See full user identity in lists';
$string['tag:create'] = 'Create new tags';
$string['tag:edit'] = 'Edit existing tags';
$string['tag:editblocks'] = 'Edit blocks in tags pages';
$string['tag:manage'] = 'Manage all tags';
$string['tag:flag'] = 'Flag tags as inappropriate';
$string['thisusersroles'] = 'This user\'s role assignments';
$string['unassignarole'] = 'Unassign role {$a}';
$string['unassignerror'] = 'Error while unassigning the role {$a->role} from user {$a->user}.';
$string['unassignconfirm'] = 'Do you really want to unassign "{$a->role}" role from user "{$a->user}"?';
$string['user:changeownpassword'] = 'Change own password';
$string['user:create'] = 'Create users';
$string['user:delete'] = 'Delete users';
$string['user:editmessageprofile'] = 'Edit user messaging profile';
$string['user:editownmessageprofile'] = 'Edit own user messaging profile';
$string['user:editownprofile'] = 'Edit own user profile';
$string['user:editprofile'] = 'Edit user profile';
$string['user:ignoreuserquota'] = 'Ignore user quota limit';
$string['user:loginas'] = 'Login as other users';
$string['user:manageblocks'] = 'Manage blocks on user profile of other users';
$string['user:manageownblocks'] = 'Manage blocks on own public user profile';
$string['user:manageownfiles'] = 'Manage files on own private file areas';
$string['user:managesyspages'] = 'Configure default page layout for public user profiles';
$string['user:readuserblogs'] = 'See all user blogs';
$string['user:readuserposts'] = 'See all user posts';
$string['user:update'] = 'Update user profiles';
$string['user:viewalldetails'] = 'View user full information';
$string['user:viewdetails'] = 'View user profiles';
$string['user:viewhiddendetails'] = 'View hidden details of users';
$string['user:viewuseractivitiesreport'] = 'See user activity reports';
$string['user:viewusergrades'] = 'View user grades';
$string['usersfrom'] = 'Users from {$a}';
$string['usersfrommatching'] = 'Users from {$a->contextname} matching \'{$a->search}\'';
$string['usersinthisx'] = 'Users in this {$a}';
$string['usersinthisxmatching'] = 'Users in this {$a->contexttype} matching \'{$a->search}\'';
$string['userswithrole'] = 'All users with a role';
$string['userswiththisrole'] = 'Users with role';
$string['useshowadvancedtochange'] = 'Use \'Show advanced\' to change';
$string['viewingdefinitionofrolex'] = 'Viewing the definition of role \'{$a}\'';
$string['viewrole'] = 'View role details';
$string['webservice:createtoken'] = 'Create a web service token';
$string['webservice:createmobiletoken'] = 'Create a web service token for mobile access';
$string['whydoesuserhavecap'] = 'Why does {$a->fullname} have capability {$a->capability} in context {$a->context}?';
$string['whydoesusernothavecap'] = 'Why does {$a->fullname} not have capability {$a->capability} in context {$a->context}?';
$string['xroleassignments'] = '{$a}\'s role assignments';
$string['xuserswiththerole'] = 'Users with the role "{$a->role}"';
