/*
YUI 3.15.0 (build 834026e)
Copyright 2014 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

YUI.add('datasource-function', function (Y, NAME) {

/**
 * Provides a DataSource implementation which can be used to retrieve data from
 * a custom function.
 *
 * @module datasource
 * @submodule datasource-function
 */

/**
 * Function subclass for the DataSource Utility.
 * @class DataSource.Function
 * @extends DataSource.Local
 * @constructor
 */
var LANG = Y.Lang,

    DSFn = function() {
        DSFn.superclass.constructor.apply(this, arguments);
    };


    /////////////////////////////////////////////////////////////////////////////
    //
    // DataSource.Function static properties
    //
    /////////////////////////////////////////////////////////////////////////////
Y.mix(DSFn, {
    /**
     * Class name.
     *
     * @property NAME
     * @type String
     * @static
     * @final
     * @value "dataSourceFunction"
     */
    NAME: "dataSourceFunction",


    /////////////////////////////////////////////////////////////////////////////
    //
    // DataSource.Function Attributes
    //
    /////////////////////////////////////////////////////////////////////////////

    ATTRS: {
        /**
        * Stores the function that will serve the response data.
        *
        * @attribute source
        * @type {Any}
        * @default null
        */
        source: {
            validator: LANG.isFunction
        }
    }
});

Y.extend(DSFn, Y.DataSource.Local, {
    /**
     * Passes query data to the source function. Fires <code>response</code>
     * event with the function results (synchronously).
     *
     * @method _defRequestFn
     * @param e {EventFacade} Event Facade with the following properties:
     * <dl>
     * <dt>tId (Number)</dt> <dd>Unique transaction ID.</dd>
     * <dt>request (Object)</dt> <dd>The request.</dd>
     * <dt>callback (Object)</dt> <dd>The callback object with the following
     * properties:
     *     <dl>
     *         <dt>success (Function)</dt> <dd>Success handler.</dd>
     *         <dt>failure (Function)</dt> <dd>Failure handler.</dd>
     *     </dl>
     * </dd>
     * <dt>cfg (Object)</dt> <dd>Configuration object.</dd>
     * </dl>
     * @protected
     */
    _defRequestFn: function(e) {
        var fn = this.get("source"),
            payload = e.details[0];

        if (fn) {
            try {
                payload.data = fn(e.request, this, e);
            } catch (ex) {
                Y.log("Function execution failure", "error", "datasource-function");
                payload.error = ex;
            }
        } else {
            Y.log("Function data failure", "error", "datasource-function");
            payload.error = new Error("Function data failure");
        }

        this.fire("data", payload);

        return e.tId;
    }
});

Y.DataSource.Function = DSFn;


}, '3.15.0', {"requires": ["datasource-local"]});
